﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using System.Text.RegularExpressions;
using System.Windows.Threading;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.Entities;




namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for CashPayment.xaml
    /// </summary>
    public partial class CashPayment : Window
    {
        static string EnteredAmount { get; set; }
        public CashPayment()
        {
            InitializeComponent();
            txtPayment.Focus();
            EnteredAmount = string.Empty;
        }

        private void LoadCurrentOrderTotal()
        {
            lblTotalAmount.Text = AppSession.CurrentOrders.Total.ToString("$ 0.00");

            decimal paid = 0, balance = 0, balanceCust = 0;
            decimal.TryParse(txtPayment.Text.Trim(), out paid);

            balance = (paid - AppSession.CurrentOrders.Total);
            balance = balance > 0 ? balance : 0;

            balanceCust = AppSession.CurrentOrders.Total - paid;
            balanceCust = balanceCust > 0 ? balanceCust : 0;

            lblBalance.Text = balance.ToString("$ 0.00");
            //lblBalanceFromCustomer.Text = balanceCust.ToString("SGD 0.00");


        }


        private void txtPayment_TextChanged(object sender, TextChangedEventArgs e)
        {
            string NewAmount = string.Empty;
            if (EnteredAmount.Length > 2)
            {
                string DecimalValue, WholeValue;
                DecimalValue = EnteredAmount.Substring(EnteredAmount.Length - 2, 2);
                WholeValue = EnteredAmount.Substring(0, EnteredAmount.Length - 2);
                NewAmount = string.Format("{0}.{1}", WholeValue, DecimalValue);
            }
            else
            {
                NewAmount = string.Format(".{0}", EnteredAmount);
            }
            txtPayment.TextChanged -= txtPayment_TextChanged;
            txtPayment.Text = NewAmount;
            txtPayment.TextChanged += txtPayment_TextChanged;
            txtPayment.CaretIndex = 0;
            LoadCurrentOrderTotal();

        }

        private void UpdateItems()
        {
            AppSession.ProductsList = ProductsBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).ToList<Products>();
            bool IsConnectedToInternet = GlobalConfigurations.AppConfiguration.IsConnectedToInternet();
            AppSession.ProductsList.OrderBy(product => product.SequenceNo).ToList().ForEach(product => product.Image1 = IsConnectedToInternet ?
                (string.IsNullOrEmpty(product.Image1) ? AppSession.ImagePath + AppSession.NoImagePath : AppSession.ImagePath + product.Image1)
                : (string.IsNullOrEmpty(product.Image1) ? AppSession.LocalImagePath + AppSession.NoImagePath : AppSession.LocalImagePath + product.Image1));
        }


        private void btnConfirmPayment_Click(object sender, RoutedEventArgs e)
        {
            if (ValidationUtility.ValidateDecimal(txtPayment.Text.Trim()))
            {
                ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                {
                    Action action = () =>
                    {
                        decimal paid = 0;
                        decimal.TryParse(txtPayment.Text.Trim(), out paid);

                        if (paid >= AppSession.CurrentOrders.Total)
                        {
                            AppSession.CurrentOrders.PaidAmount = paid;
                            AppSession.CurrentOrders.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;
                            AppSession.CurrentOrders.IsShipToBillingAddress = true;
                            AppSession.CurrentOrders.OrderFrom = AppSession.OrderFrom;
                            AppSession.CurrentOrders.PaymentMethod = "Cash";
                            AppSession.CurrentOrders.PaymentStatus = (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total) ? "Completed" : "Pending";
                            AppSession.CurrentOrders.OrderStatus = "Delivered";

                            int days = AppSession.CurrentOrders.OrdersDetailsList.Max(i => i.EarliestAvailableDays);
                            AppSession.CurrentOrders.EarliestAvailableDate = DateTime.Now.AddDays(days);

                            if (OrdersBL.Save(AppSession.CurrentOrders))
                            {
                                OrdersBL.GenerateInvoice(AppSession.CurrentOrders.UniqueID);
                                AppSession.CurrentOrders = OrdersBL.GetItem(AppSession.CurrentOrders.UniqueID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                                AppSession.UpdateOrderProductQty(AppSession.CurrentOrders);
                                UpdateItems();
                            }
                        }
                        else
                        {
                            MessageBox.Show("Received payment is lesser than bill amount", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                            
                        }
                    };
                    Dispatcher.BeginInvoke(DispatcherPriority.Send, action);
                });

                if (!result.OperationFailed)
                {
                    this.Tag = true;
                    this.Close();
                }
                else
                    MessageBox.Show(result.Error.Message);
            }
            else
            {
                MessageBox.Show("Please enter valid Amount", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                txtPayment.Focus();
            }
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            LoadCurrentOrderTotal();
        }

        private void btnCancelPayment_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void txtPayment_KeyDown_1(object sender, KeyEventArgs e)
        {
            if ((e.Key >= Key.NumPad0 && e.Key <= Key.NumPad9) || (e.Key >=Key.D0 && e.Key<=Key.D9))
            {
                EnteredAmount += e.Key.ToString().ToLower().Replace("numpad", ""); 
                e.Handled = false;
            }
            else
                e.Handled = true;
        }
        
    }
}
